<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Validator;

use Symfony\Component\Validator\Constraint;

/**
 * @Annotation
 * @Target({"CLASS", "PROPERTY", "ANNOTATION"})
 */
class AdeUserCredentials extends Constraint
{
    /**
     * @var bool
     *
     * @readonly
     */
    public $sandbox = false;

    public function getTargets(): array
    {
        return [self::PROPERTY_CONSTRAINT, self::CLASS_CONSTRAINT];
    }

    public function getDefaultOption(): string
    {
        return 'sandbox';
    }
}
