<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Gls\GlsPoland\Entity\CheckoutSession;

/**
 * @extends ServiceEntityRepository<CheckoutSession>
 *
 * @method CheckoutSession|null find($id, $lockMode = null, $lockVersion = null)
 * @method CheckoutSession|null findOneBy(array $criteria, array $orderBy = null)
 * @method CheckoutSession[] findAll()
 * @method CheckoutSession[] findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class CheckoutSessionRepository extends EntityRepository
{
    public function add(CheckoutSession $entity, bool $flush = true): void
    {
        $entityManager = $this->getEntityManager();
        $entityManager->persist($entity);
        if ($flush) {
            $entityManager->flush();
        }
    }

    public function remove(CheckoutSession $entity, bool $flush = true): void
    {
        $entityManager = $this->getEntityManager();
        $entityManager->remove($entity);
        if ($flush) {
            $entityManager->flush();
        }
    }

    protected static function getEntityClass(): string
    {
        return CheckoutSession::class;
    }
}
