<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Admin;

use Gls\GlsPoland\Controller\Admin\ConsignmentController;
use Gls\GlsPoland\PrestaShop\Hook\PrestaShopVersionAwareHookInterface;
use Gls\GlsPoland\PrestaShop\Hook\VersionRange;
use PrestaShopBundle\Security\Voter\PageVoter;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Twig\Environment;

final class DisplayAdminOrderTabLink implements PrestaShopVersionAwareHookInterface
{
    public const HOOK_NAME = 'displayAdminOrderTabLink';

    private $authorizationChecker;
    private $twig;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker, Environment $twig)
    {
        $this->authorizationChecker = $authorizationChecker;
        $this->twig = $twig;
    }

    public static function getVersionRange(): VersionRange
    {
        return new VersionRange('1.7.7');
    }

    public function execute(array $parameters): string
    {
        if (!$this->authorizationChecker->isGranted(PageVoter::READ, ConsignmentController::TAB_NAME)) {
            return '';
        }

        return $this->twig->render('@Modules/glspoland/views/templates/hook/admin_order_tab_link.html.twig');
    }
}
