<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Pickup;

use Gls\GlsPoland\AdePlus\Common\Id;
use Gls\GlsPoland\Entity\Consignment;
use Gls\GlsPoland\EventDispatcher\Event;

final class PickupCreatedEvent extends Event
{
    private $pickupId;
    private $consignments;

    public function __construct(Id $pickupId, Consignment ...$consignments)
    {
        $this->pickupId = $pickupId;
        $this->consignments = $consignments;
    }

    public function getPickupId(): Id
    {
        return $this->pickupId;
    }

    /**
     * @return Consignment[]
     */
    public function getConsignments(): array
    {
        return $this->consignments;
    }
}
