<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Consignment\DTO\Parcel;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ParcelType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('weightKg', NumberType::class, [
                'label' => $this->getTranslator()->trans('Weight', [], 'Admin.Global'),
                'html5' => true,
                'attr' => [
                    'step' => 'any',
                ],
                'unit' => 'kg',
            ])
            ->add('reference', TextType::class, [
                'label' => $this->getTranslator()->trans('Reference', [], 'Admin.Global'),
                'required' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('data_class', Parcel::class);
    }
}
