<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Authorization;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class Session implements ResultInterface, \JsonSerializable
{
    private $session;

    private function __construct(string $session)
    {
        $this->session = $session;
    }

    public function getValue(): string
    {
        return $this->session;
    }

    public function jsonSerialize(): array
    {
        return [];
    }

    public function __debugInfo(): array
    {
        return [];
    }
}
